document.addEventListener('DOMContentLoaded', function () {
    // Add event listeners for buttons/links
    const loginButton = document.getElementById('loginButton');
    const forgetPasswordForm = document.getElementById('forgetPasswordForm');
    const helpdeskForm = document.getElementById('helpdeskForm');
    const createAccountForm = document.getElementById('createAccountForm');
    const loginForm=document.getElementById('login-form');

    if (loginButton) {
        loginButton.addEventListener('click', loginPopup);
    }
    if (forgetPasswordForm) {
        forgetPasswordForm.addEventListener('click', forgetPasswordPopup);
    }
    if (helpdeskForm) {
        helpdeskForm.addEventListener('click', helpdeskPopup);
    }
    if (createAccountForm) {
        createAccountForm.addEventListener('click', createAccountPopup);
    }

    // Add event listener for form submission
  
    if(loginForm){
        loginForm.addEventListener('submit',submitLoginForm );
    }
    // Add event listeners for chat functionality
    const sendButton = document.getElementById('send-button');
    if (sendButton) {
        sendButton.addEventListener('click', sendMessage);
    }

    const inputField = document.getElementById('user-input');
    if (inputField) {
        inputField.addEventListener('keypress', handleKeyPress);
    }

    // // Load initial content
     loadContent();
    









});

// Function to open login popup
function loginPopup() {
    console.log('Login popup opened');
    hideAllPopups();
    document.getElementById('login-popup').style.display = 'flex';
}


// Function to open forgot password popup
function forgetPasswordPopup() {
    console.log('Forgot password popup opened');
    hideAllPopups();
    document.getElementById('forgot-password-popup').style.display = 'flex';
}

// Function to open help desk popup
function helpdeskPopup() {
    console.log('Help desk popup opened');
    hideAllPopups();
    document.getElementById('help-popup').style.display = 'flex';
}

// Function to open create account popup
function createAccountPopup() {
    console.log('Create account popup opened');
    hideAllPopups();
    document.getElementById('create-account-popup').style.display = 'flex';
}

// Function to hide all popups
function hideAllPopups() {
    const popups = document.querySelectorAll('.popup');
    popups.forEach(popup => {
        popup.style.display = 'none';
    });
}

// Function to load content
function loadContent() {
    const loader = document.getElementById('loader');
    const content = document.getElementById('content');

    if (loader && content) {
        loader.style.display = 'flex';
        content.style.display = 'none';

        setTimeout(() => {
            fetch('/litmac/authentication/create-store/create-account.php')
                .then(response => {
                    if (!response.ok) throw new Error('Network response was not ok');
                    return response.text();
                })
                .then(data => {
                    content.innerHTML = data;
                    loader.style.display = 'none';
                    content.style.display = 'block';
                    
                    // Initialize form steps AFTER content is loaded
                    nextoptions();
                    showpassword();
                      const createAccountFormElement = document.getElementById('create-account-form');
                    if (createAccountFormElement) {
                        createAccountFormElement.addEventListener('submit', submitCreateAccountForm);
                    }
                })
                .catch(error => {
                    console.error('Error loading page:', error);
                    loader.innerHTML = "<p style='color:red;'>Failed to load content. Please try again.</p>";
                });
        }, 1000);
       
    }
}
function showpassword(){
   document.getElementById('togglePassword').addEventListener('click', function () {
    const passwordInput = document.getElementById('password');
    const icon = this;
    const isPassword = passwordInput.type === 'password';

    passwordInput.type = isPassword ? 'text' : 'password';
    icon.classList.toggle('fa-eye');
    icon.classList.toggle('fa-eye-slash');
  });
}
function nextoptions() {
    // Only initialize form steps if the container exists
    const formSteps = document.querySelectorAll('.form-step');
    if (formSteps.length > 0) {
        function validateStep(stepNumber) {
            const currentStep = document.getElementById(`step-${stepNumber}`);
            const inputs = currentStep.querySelectorAll('input[required], select[required]');
            
            for (let input of inputs) {
                if (!input.value.trim()) {
                    input.focus();
                    showAlertNow(`Please fill in ${input.previousElementSibling?.textContent || 'this field'}`, 'error');
                    return false;
                }
                
                // Add specific validation for different field types
                if (input.type === 'email' && !isValidEmail(input.value)) {
                    input.focus();
                    showAlertNow('Please enter a valid email address', 'error');
                    return false;
                }
                
                if (input.id === 'company_phone_number' && !isValidPhone(input.value)) {
                    input.focus();
                    showAlertNow('Please enter a valid phone number', 'error');
                    return false;
                }
            }
            return true;
        }

        function showStep(stepNumber) {
            const formSteps = document.querySelectorAll('.form-step');
            if (!formSteps.length) return;
            
            formSteps.forEach(step => {
                if (step.style) step.style.display = 'none';
            });
            
            const stepElement = document.getElementById(`step-${stepNumber}`);
            if (stepElement && stepElement.style) {
                stepElement.style.display = 'block';
                updateProgress(stepNumber);
            }
        }

        function updateProgress(activeStep) {
            const progressSteps = document.querySelectorAll('.progress-bar span');
            if (!progressSteps.length) return;
            
            progressSteps.forEach((step, index) => {
                if (step.classList) {
                    step.classList.toggle('active', index + 1 === activeStep);
                }
            });
        }

        // Helper validation functions
        function isValidEmail(email) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
        }

        function isValidPhone(phone) {
            return /^\d{10,15}$/.test(phone);
        }

        // Next step buttons
        document.querySelectorAll('.next-step').forEach(button => {
            button.addEventListener('click', function() {
                const currentStep = this.closest('.form-step').id.replace('step-', '');
                if (validateStep(currentStep)) {
                    const targetStep = parseInt(this.getAttribute('data-target'));
                    showStep(targetStep);
                }
            });
        });

        // Previous step buttons
        document.querySelectorAll('.prev-step').forEach(button => {
            button.addEventListener('click', function() {
                const targetStep = parseInt(this.getAttribute('data-target'));
                showStep(targetStep);
            });
        });

        // Only show first step if there are steps
        showStep(1);
    }
}
// Function to send chat message
function sendMessage() {
    const inputField = document.getElementById('user-input');
    const message = inputField.value.trim();
    if (message === '') return;

    const chatBox = document.getElementById('chat-box');
    const userMessage = `<p><strong>You:</strong> ${message}</p>`;
    chatBox.innerHTML += userMessage;

    // Simulate a support response
    setTimeout(() => {
        const botResponse = `<p><strong>Support:</strong> We're looking into your issue.</p>`;
        chatBox.innerHTML += botResponse;
        chatBox.scrollTop = chatBox.scrollHeight;
    }, 1000);

    inputField.value = '';
}

// Function to handle Enter key in chat
function handleKeyPress(event) {
    if (event.key === 'Enter' && !event.shiftKey) {
        event.preventDefault();
        sendMessage();
    }
}

function submitCreateAccountForm(event) {
    console.log("Form submission started");
    event.preventDefault();

    // Get all form data
    const form = document.getElementById('create-account-form');
    const formData = new FormData(form);
    
    // Combine phone number
    const countryCode = document.getElementById('country_codes').value;
    const phoneNumber = document.getElementById('company_phone_number').value;
    formData.append('company_phone', countryCode + phoneNumber);

    // Show loading indicator
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalBtnText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Processing...';
    submitBtn.disabled = true;

    // Send request
    fetch('/litmac/authentication/create-store/create_accountserver.php', {
        method: 'POST',
        body: formData,
        headers: {
            'Accept': 'application/json'
        }
    })
    .then(response => {
        console.log("Received response status:", response.status);
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        console.log("Response data:", data);
        if (data.success) {
            // Show success message and redirect
            showAlertNow(data.message, 'success');
            
            // Redirect after 2 seconds to allow user to see the message
            setTimeout(() => {
                window.location.href = data.redirect || '/litmac/authentication/login/login.php';
            }, 2000);
        } else {
            // Handle email/username suggestions
            const suggestionContainer = document.getElementById('username-suggestion');
            const suggestionSpan = document.getElementById('suggested-username');
            
            // Check if message contains suggested username
            const usernameMatch = data.message.match(/Suggested username:\s*(\w+)/i);
            if (usernameMatch) {
                const suggested = usernameMatch[1];
                suggestionSpan.textContent = suggested;
                suggestionContainer.style.display = 'block';

                // Allow user to click to use the suggested name
                suggestionContainer.onclick = () => {
                    document.getElementById('username').value = suggested;
                    suggestionContainer.style.display = 'none';
                };
            } else {
                suggestionContainer.style.display = 'none';
            }
            
            showAlertNow(data.message, 'error');
        }
    })
    .catch(error => {
        console.error('Fetch error:', error);
        showAlertNow('An error occurred while submitting the form. Please try again.', 'error');
    })
    .finally(() => {
        // Restore button state
        submitBtn.innerHTML = originalBtnText;
        submitBtn.disabled = false;
    });
}
// Function to handle user login



function submitLoginForm(event) {
    event.preventDefault(); 

    const form = document.getElementById('login-form');
    const formData = new FormData(form);

    fetch('/litmac/authentication/login/login.php', {
        method: 'POST',
        body: formData,
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlertNow('Login Successful!', "success");
            window.location.href = data.redirect;
        } else {
            showAlertNow(data.message || 'Error logging in.');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showAlertNow('An error occurred while logging in. Please try again.');
    });
}



function showAlertNow(message, type) {
    // Create alert container if it doesn't exist
    let alertContainer = document.getElementById('custom-alert-container');
    if (!alertContainer) {
        alertContainer = document.createElement('div');
        alertContainer.id = 'custom-alert-container';
        alertContainer.style.position = 'fixed';
        alertContainer.style.top = '20px';
        alertContainer.style.right = '20px';
        alertContainer.style.zIndex = '1000';
        document.body.appendChild(alertContainer);
    }

    // Create alert element
    const alert = document.createElement('div');
    alert.className = 'custom-alert';
    alert.style.padding = '15px 20px';
    alert.style.marginBottom = '10px';
    alert.style.borderRadius = '4px';
    alert.style.color = 'white';
    alert.style.fontWeight = 'bold';
    alert.style.boxShadow = '0 4px 8px rgba(0,0,0,0.1)';
    alert.style.display = 'flex';
    alert.style.alignItems = 'center';
    alert.style.gap = '10px';
    alert.style.animation = 'slideIn 0.3s ease-out';
    
    // Set colors based on type
    if (type === 'success') {
        alert.style.backgroundColor = '#007bff'; 
    } else {
        alert.style.backgroundColor = '#dc3545'; // Red
    }

    // Add icon
    const icon = document.createElement('i');
    icon.className = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-circle';
    alert.appendChild(icon);

    // Add message
    const text = document.createElement('span');
    text.textContent = message;
    alert.appendChild(text);

    // Add to container
    alertContainer.appendChild(alert);

    // Remove after delay
    setTimeout(() => {
        alert.style.animation = 'fadeOut 0.3s ease-out';
        setTimeout(() => {
            alert.remove();
            // Remove container if no more alerts
            if (alertContainer.children.length === 0) {
                alertContainer.remove();
            }
        }, 300);
    }, 3000);

    // Add CSS animations if not already present
    if (!document.getElementById('alert-animations')) {
        const style = document.createElement('style');
        style.id = 'alert-animations';
        style.textContent = `
            @keyframes slideIn {
                from { transform: translateX(100%); opacity: 0; }
                to { transform: translateX(0); opacity: 1; }
            }
            @keyframes fadeOut {
                from { opacity: 1; }
                to { opacity: 0; }
            }
        `;
        document.head.appendChild(style);
    }
}
