
<form id="create-account-form" method="POST">
  <!-- Progress Navigation -->
  <div class="progress-bar">
    <span id="progress-step-1" class="active">Step 1 &raquo; Company Info</span>
    <span id="progress-step-2">Step 2 &raquo; Business Category</span>
    <span id="progress-step-3">Step 3 &raquo; Credentials</span>
  </div>

  <!-- Step 1 -->
  <div class="form-step" id="step-1">
    <h1>Create Company Account</h1>
    <div class="form-group">
      <label for="company_name">Company Name:</label>
      <input type="text" id="company_name" name="company_name" required>
    </div>
    <div class="form-group">
      <label for="company_address">Company Address:</label>
      <input type="text" id="company_address" name="company_address" required>
    </div>
    <div class="form-group">
      <label for="company_email">Company Email:</label>
      <input type="email" id="company_email" name="company_email" required>
    </div>
    <div class="form-group" style="display: flex; gap: 10px;">
      <label for="company_phone_number">Company Phone:</label>
      <select id="country_codes" name="country_codes" required>
        <option value="+234">+234 (NGN)</option>
        <option value="+1">+1 (USA)</option>
        <option value="+44">+44 (UK)</option>
        <option value="+233">+233 (Ghana)</option>
        <option value="+27">+27 (South Africa)</option>
      </select>
      <input type="tel" id="company_phone_number" name="company_phone_number" placeholder="Enter company phone" required>
    </div>
    <input type="hidden" id="full_phone_number" name="full_phone_number">
    <div class="form-navigation">
      <button type="button" class="next-step" data-target="2">Next &raquo;</button>
    </div>
  </div>

  <!-- Step 2 -->
  <div class="form-step" id="step-2" style="display:none;">
    <h2>Select Business Category</h2>
    <div class="form-group">
      <label for="business_category">Business Category:</label>
      <select id="business_category" name="business_category" required>
        <option value="">-- Select Category --</option>
        <option value="super_market">Super Market</option>
        <option value="farm_birds">Farm Birds Business</option>
        <option value="bakery">Bakery</option>
        <option value="fast_foods">Fast Foods</option>
        <option value="hotels_bars">Hotels and Bars</option>
      </select>
    </div>
    <div class="form-navigation">
      <button type="button" class="prev-step" data-target="1">&laquo; Back</button>
      <button type="button" class="next-step" data-target="3">Next &raquo;</button>
    </div>
  </div>

  <!-- Step 3 -->
  <div class="form-step" id="step-3" style="display:none;">
  <div class="form-group">
  <label for="username">Username:</label>
  <input type="text" id="username" name="username" required>
  <div id="username-suggestion" style="display: none; margin-top: 5px; color: #007bff; cursor: pointer;">
    Suggested username: <span id="suggested-username" style="font-weight: bold;"></span>
  </div>
</div>

 <div class="form-group" style="position: relative; width: 100%;">
  <label for="password">Password:</label>
  <input
    type="password"
    id="password"
    name="password"
    required
    style="width: 100%; padding-right: 40px; box-sizing: border-box;"
  >
  <i
    id="togglePassword"
    class="fa-solid fa-eye"
    style="
      position: absolute;
      right: 10px;
      top: 38px;
      transform: translateY(-50%);
      cursor: pointer;
      color: #888;
    "
  ></i>
</div>


    <div class="form-navigation">
      <button type="button" class="prev-step" data-target="2">&laquo; Back</button>
      <button type="submit">Create Account</button>
    </div>

  </div>
</form>

