function showAlert(message) {
    setTimeout(() => {
        const alertBox = document.getElementById('custom-alert');
        if (alertBox) {
            const alertMessage = document.getElementById('alert-message');
            alertMessage.textContent = message; // Set the message
            alertBox.style.display = 'flex'; // Show the alert
        } else {
            console.error("showAlert: Element #custom-alert not found.");
        }
    }, 500); // Delay to allow element to load
}


// Function to hide the custom alert
function hideAlert() {
    document.getElementById('custom-alert').style.display = 'none';
}

// Wait for the DOM to be fully loaded
document.addEventListener("DOMContentLoaded", function () {
    // Add event listener to the close icon
    document.getElementById('close-alert').addEventListener('click', hideAlert);

    // Add event listener to the OK button
    document.getElementById('alert-ok').addEventListener('click', hideAlert);
});
